﻿<?LassoScript

	/*
			This page lists a top level message and all the replies to it. This
		page also permits a user to post an additional reply to the message.
		Collectively, the original message and all of its replies are called a
		"thread". 

			The top level message is always displayed and users are 
		allowed to page through the replies, N at a time. The 'skip' action
		param indicates which group of N to show. Skip starts at 0, indicating
		that message 1 through N should be shown. To show the next N messages,
		skip would be set to skip + N.
		
			If this page is called with a $LJAX page variable set to true, then
		only the visible replies, based on the #skip and $max values will be
		shown. The top-level message will not be included. This allows this page
		to be directly targetted by an AJAX request. It is also opermitted to
		post a new message reply via AJAX.
	*/
	if (action_param('detail')->size);
		local('threadId' = integer(action_param('detail')));
		local('skip' = integer(action_param('skip')));

		local('newReply'=action_param('newReply'),
				'newTitle'=action_param('title'),
				'newBody'=action_param('body'));

		local('author'=action_param('authorFilter'),
				'body'=action_param('bodyFilter'));
		#author->trim;
		#body->trim;
		
		// see if the admin is deleting one of the messages
		if ($isAdmin && action_param('delmid'));
			local('delMID' = action_param('delmid'));
			inline(-database='op_message_board', -table='messages', -delete, 
					-keyField='id', -keyValue=#delMID);
				inline(-delete, -keyField='id_reply', -keyValue=#delMID);/inline;
			/inline;
		/if;
		
		
		// look up the first message in the thread
		// using this id. this message must not have an id_reply column value.
		// if it does, fall through and just display the forum list
		inline(-database='op_message_board', -table='messages', -search,
				-op='eq', 'id'=#threadId, -op='eq', 'id_reply'=null,
				-returnField='title', -returnField='body', -returnField='date', -returnField='id_author',
				-returnField='id_forum');
			if (found_count != 0);
				$handled = true;

				local('forumId' = field('id_forum'));
ljax_target(-notarget); // no ajax only
				'<div class="left_bar">\
				<b class="rboth1 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth4 rleftclr"></b>';
/ljax_target;
ljax_target(-target=array('reply_group', 'auth_group'), -notarget);
				/*
					The user may initially not be logged in, but may be authenticated via a LJAX call.
					This means the username is changing dynamically, so we need to update the UI.
				*/
				'<span id="login_info" xmlns="http://www.w3.org/1999/xhtml" class="group_title">\
				Hello, <i>'admin_currentusername'</i>';
				if (!$isLoggedIn);
					' <a href="' Application_appInfo->indexFile '?auth=1">(login)</a>';
				/if;
				'</span>';
/ljax_target;
ljax_target(-notarget); // no ljax here
				'<b class="rboth4 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth1 rleftclr"></b>';
				'</div>';
				'<div class="group_list">\
					<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
						<div class="group_title">'
							
							'<a href="' Application_appInfo->indexFile '">Forums</a> &gt; ';
							// display this forum's name
							inline(-table='forums', -search, -op='eq', 'id'=#forumId,
									-returnField='title');
								'<a href="' Application_appInfo->indexFile '?list=' #forumId '">'
								encode_html(field('title'))
								'</a> &gt; ';
							/inline;							
							encode_html(field('title'))
						'</div>\
						<div class="item">\
							<table><tr><td>\
							<div class="avatar">'
								// put the image here
								encode_html(MessageBoard_findAuthorById(field('id_author')))
								'<br />'
								encode_html(field('date'))
							'</div></td><td>\
							<span class="message_body">'								
								encode_break(field('body'))
							'</span></td></tr></table>\
						</div>\
					</div>';
					// Here is the Create New Reply section
					'<div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">\
							<a href="#" onclick="toggleDisplayBlock(\'new_reply_form_parent\')">Create New Reply</a>\
						</div>\
						<div class="item" id="new_reply_form_parent">\
							<form id="new_reply_form" method="POST" action="'response_filepath'" 
									onsubmit="var t = this; Lasso.includeTarget(\'reply_group\', {args:this, afterFunc:function(){t.reset(); toggleDisplayBlock(\'new_reply_form_parent\');}}); return false;">\
								Title<br /><input type="text" name="title" size="50" value="Re: 'field('title')'" /><br />\
								Body<br /><textarea name="body" style="width: 80%; height: 100px"></textarea><br />\
								<input type="hidden" name="detail" value="'#threadId'" />\
								<input type="hidden" name="skip" value="'#skip'" />\
								<input type="submit" value="Submit Reply" name="newReply" />\
							</form>\
						</div>\
					</div>';
/ljax_target; //  end of non-LJAX only section	
				// see if a new message reply is being posted
				if (#newReply);
					if (!$isLoggedIn); // must be authenticated
						auth;
					/if;
					if (#newTitle->size == 0);
						#newTitle = '(no title)';
					/if;
					inline(-table='messages', 
							'title'=#newTitle, 'body'=#newBody, 
							'id_author'=MessageBoard_findAuthorByName(admin_currentusername), 
							'id_reply'=#threadId, 'id_forum'=#forumId, -add);
						inline(-table='messages', -search, -returnField='id', -op='eq', 'id_reply'=#threadId);
							#skip = found_count-1;
						/inline;
					/inline;
				/if;					

				// check the filters
				if (#author);
					inline(-table='authors', -search, -op='ct', 'name'=#author, -returnField='id', -maxrecords='all');
						local('authorFilter' = array(-opbegin='or'));
						if (found_count > 0);
							records;
								#authorFilter->insert(-op='eq') & insert('id_author'=field('id'));
							/records;
							#authorFilter->insert(-opend);
						else;
							// value provided but no authors matched
							#authorFilter->insert(-op='eq') & insert('id_author'= -1);
						/if;
					/inline;
				/if;
				if (#body);
					local('bodyFilter' = array(-opbegin='or', -op='ct', 'body'=#body, -op='ct', 'title'=#body, -opend));
				/if;
				// find all the replies
				inline(-table='messages', -search, -maxrecords=$max, -skiprecords= #skip, 
						-op='eq', 'id_reply'=#threadId, local('authorFilter'), local('bodyFilter'),
						-returnField='id', -returnField='title', -returnField='body', -returnField='date', -returnField='id_author', -sortField='date');
ljax_target(-notarget);
					'<div><div class="group">\
						<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
						<div class="group_title">';
/ljax_target;
ljax_target('reply_group', -notarget);
							'<span class="ghostly" id="shown_info" xmlns="http://www.w3.org/1999/xhtml">';
							if (found_count == 0); // no replies
								'There are no replies to this message.';
							else (found_count == 1);
								'Showing the single reply.';
							else (found_count == shown_count);
								'Showing all of the ' found_count ' replies.';
							else ($max == 1 || shown_count == 1);
								'Showing reply ' (#skip+1) ' of ' found_count ' replies.';
							else;
								'Showing ' (#skip+1) ' through ' (#skip + shown_count) ' of ' found_count ' replies.';
							/if;
							'</span>';
/ljax_target;
ljax_target(-notarget);
							'<form method="POST" action="'Application_appInfo->indexFile'">';
/ljax_target;
ljax_target('reply_group', -notarget);
							'<span class="page_nav" id="nav_control" xmlns="http://www.w3.org/1999/xhtml">&#160;&#160;';
							if (#skip != 0 && $max != 'all');
								'<a onclick="Lasso.includeTarget(\'reply_group\', {args:this}); return false;" href="' Application_appInfo->indexFile '?detail=' #threadId '&#38;skip=0&#38;authorFilter='#author'&#38;bodyFilter='#body'"> &#171; </a> ';
								'<a onclick="Lasso.includeTarget(\'reply_group\', {args:this}); return false;" href="' Application_appInfo->indexFile '?detail=' #threadId '&#38;skip=' ((#skip-$max) > -1 ? (#skip-$max) | 0) '&#38;authorFilter='#author'&#38;bodyFilter='#body'"> &#8249; </a> ';
							else;
								' &#171; &#8249; ';
							/if;
							// allow the user to select the number of replies per page to show
							'<input type="hidden" name="skip" value="'#skip'" />\
							<input type="hidden" name="detail" value="'#threadId'" />\
							<select name="max" onchange="Lasso.includeTarget(\'reply_group\', {args:this.form});">\
								<option value="1"' ($max == 1? ' selected="true"') '>1</option>\
								<option value="3"' ($max == 3? ' selected="true"') '>3</option>\
								<option value="5"' ($max == 5? ' selected="true"') '>5</option>\
								<option value="10"' ($max == 10? ' selected="true"') '>10</option>\
								<option value="all"' ($max == 'all'? ' selected="true"') '>all</option>\
							</select>';
							// Safari has a bug whereby dynamically inserted nodes will not respect the <noscript> tags
							// So all noscript stuff ends up being visible after LJAX inserts it into the page
							// Adding an LJAX -notarget here insures that this section is not sent
							// if the current request is an LJAX request
ljax_target(-notarget);
							'<noscript>\
							<input type="submit" name="Select" value="Select" />\
							</noscript>';
/ljax_target;
							if ( $max != 'all' && (#skip+$max) < found_count);
								'<a onclick="Lasso.includeTarget(\'reply_group\', {args:this}); return false;" href="' Application_appInfo->indexFile '?detail=' #threadId '&#38;skip=' (#skip+$max) '&#38;authorFilter='#author'&#38;bodyFilter='#body'"> &#8250; </a> ';
								'<a onclick="Lasso.includeTarget(\'reply_group\', {args:this}); return false;" href="' Application_appInfo->indexFile '?detail=' #threadId '&#38;skip=' (found_count-$max) '&#38;authorFilter='#author'&#38;bodyFilter='#body'"> &#187; </a>';
							else;
								' &#8250; &#187;';
							/if;									
							'&#160;&#160;</span>';
/ljax_target;
ljax_target(-notarget);
							'<span class="ghostly">author</span> \
							<input class="filter" id="author_filter" type="text" name="authorFilter" value="'#author'" 
								onkeyup="var t = this; filterUpdate(function() {
										Lasso.includeTarget(\'reply_group\', {args:t.form, argsoverride:{skip:0}});})" /> \
							<span class="ghostly">body/title</span> \
							<input class="filter" id="body_filter" type="text" name="bodyFilter" value="'#body'" 
								onkeyup="var t = this; filterUpdate(function() {
										Lasso.includeTarget(\'reply_group\', {args:t.form, argsoverride:{skip:0}});})" />';
							// Safari has a bug whereby dynamically inserted nodes will not respect the <noscript> tags
							// So all noscript stuff ends up being visible after LJAX inserts it into the page
							// Adding an LJAX -notarget here insures that this section is not sent
							// if the current request is an LJAX request
							'<noscript>\
							<input type="submit" name="Filter" value="Filter" />\
							</noscript>';
							'</form>';
						'</div>';
/ljax_target;
ljax_target('reply_group', -notarget); // when -target=reply_group, or no target at all
						'<div id="reply_group" xmlns="http://www.w3.org/1999/xhtml">';
						records;
							'<div class="item">\
								<div class="item_title">'
									encode_html(field('title'));
									$isAdmin? (' - <a onclick="Lasso.includeTarget(\'reply_group\', {args:this}); return false;" class="delete" href="' Application_appInfo->indexFile '?delmid='field('id')'&#38;detail='#threadId'">(delete message)</a>');
								'</div>\
								<table><tr><td>\
								<div class="avatar">'
									// put the image here
									encode_html(MessageBoard_findAuthorById(field('id_author')))
									'<br />'
									encode_html(field('date'))
								'</div></td><td>\
								<span class="message_body">'								
									encode_break(field('body'))
								'</span></td></tr></table>\
							</div>';
						/records;
						'</div>';
/ljax_target;
ljax_target(-notarget);
					'</div></div>';
/ljax_target;
				/inline;
ljax_target(-notarget);
				'</div>';
/ljax_target;
			/if;
		/inline;
	/if;
?>